double importPopulationData()
{/*ALCODESTART::1737124079652*/
String populationProjectionFile = "";
switch (this.populationProjectionName) {
	case "Low-growth":		populationProjectionFile = "1710005701-LG";
							break;
	case "Medium-growth 1":	populationProjectionFile = "1710005701-M1";
							break;
	case "Medium-growth 2":	populationProjectionFile = "1710005701-M2";
							break;
	case "Medium-growth 3":	populationProjectionFile = "1710005701-M3";
							break;
	case "Medium-growth 4":	populationProjectionFile = "1710005701-M4";
							break;
	case "Medium-growth 5":	populationProjectionFile = "1710005701-M5";
							break;
	case "Medium-growth 6":	populationProjectionFile = "1710005701-M6";
							break;
	case "High-growth":		populationProjectionFile = "1710005701-HG";
							break;
	case "Slow-aging":		populationProjectionFile = "1710005701-SA";
							break;
	case "Fast-aging":		populationProjectionFile = "1710005701-FA";
							break;
	default:				error("The Population Projection Type selected is not supported. Please contact the model administrator");
							break;						
}

this.historicPopulationData = this.readPopulationData(this.populationHistoricName);

this.projectionPopulationData = this.readPopulationData(populationProjectionFile);

/*ALCODEEND*/}

HashMap<Integer, HashMap<String, HashMap<String, HashMap<String, Integer>>>> readPopulationData(String fileName)
{/*ALCODESTART::1737125367829*/
String filePath = "./data/" + fileName + ".csv";
File f = new File(filePath);

if(!f.exists() || f.isDirectory()) {
	error("The filename: \"" + fileName + "\" does not exist in the data folder.");
}

HashMap<Integer, HashMap<String, HashMap<String, HashMap<String, Integer>>>> popMap = new HashMap<>();

String line;
String[] columnNames = new String[0];
int dataLineCount = 0;
int yearIdx = -1;
int geographyIdx = -1;
int ageIdx = -1;
int genderIdx = -1;
int populationIdx = -1;

try (BufferedReader br = new BufferedReader(new FileReader(filePath))) {
	while((line = br.readLine()) != null) {
	
		dataLineCount++;
		
		if(dataLineCount == 1) {
			List columnNamesList = Arrays.asList(line.split(","));
			yearIdx = columnNamesList.indexOf("YEAR");
			geographyIdx = columnNamesList.indexOf("GEOGRAPHY");
			ageIdx = columnNamesList.indexOf("AGE_GROUP");
			genderIdx = columnNamesList.indexOf("GENDER");
			populationIdx = columnNamesList.indexOf("PROJECTED_VALUE");
			continue;
		}

		String[] lineParts = line.split(",");
		
		int year = Integer.valueOf(lineParts[yearIdx]);
		String geography = lineParts[geographyIdx];
		String ageGroup = lineParts[ageIdx];
		String gender = lineParts[genderIdx];
		int population = Integer.valueOf(lineParts[populationIdx]);
		
		if(!popMap.containsKey(year)) {
			popMap.put(year, new HashMap<>());
		}
		if(!popMap.get(year).containsKey(geography)) {
			popMap.get(year).put(geography, new HashMap<>());
		}
		if(!popMap.get(year).get(geography).containsKey(ageGroup)) {
			popMap.get(year).get(geography).put(ageGroup, new HashMap<>());
		}
		if(!popMap.get(year).get(geography).get(ageGroup).containsKey(gender)) {
			popMap.get(year).get(geography).get(ageGroup).put(gender, population);
		}

	}
}
catch (FileNotFoundException ex) {
	error(ex.getMessage());
}
catch (IOException ex) {
	error(ex.getMessage());
}
return popMap;
/*ALCODEEND*/}

double aggregateCurrentYearPopulations()
{/*ALCODESTART::1737147102192*/
int currentYear = this.getYear();

HashMap<String, Integer> provincePopulationCountAll = new HashMap<>();
HashMap<String, Integer> provincePopulationCount65Plus = new HashMap<>();
HashMap<String, Integer> provincePopulationCount75Plus = new HashMap<>();

for(String province : provinceList) {
	int countAll = 0;
	int count65Plus = 0;
	int count75Plus = 0;
	for(String gender : (currentYear > this.getHistoricPopulationMaxYear() ? genderList : sexList)) {
		for(String age : ageListAll) {
			if(currentYear <= this.getHistoricPopulationMaxYear()) {
				countAll += this.historicPopulationData.get(currentYear).get(province).get(age).get(gender);
			} else {
				countAll += this.projectionPopulationData.get(currentYear).get(province).get(age).get(gender);
			}
		}
		
		for(String age : ageList65Plus) {
			if(currentYear <= this.getHistoricPopulationMaxYear()) {
				count65Plus += this.historicPopulationData.get(currentYear).get(province).get(age).get(gender);
			} else {
				count65Plus += this.projectionPopulationData.get(currentYear).get(province).get(age).get(gender);
			}
		}
		
		for(String age : ageList75Plus) {
			if(currentYear <= this.getHistoricPopulationMaxYear()) {
				count75Plus += this.historicPopulationData.get(currentYear).get(province).get(age).get(gender);
			} else {
				count75Plus += this.projectionPopulationData.get(currentYear).get(province).get(age).get(gender);
			}
		}
	}
	provincePopulationCountAll.put(province, countAll);
	provincePopulationCount65Plus.put(province, count65Plus);
	provincePopulationCount75Plus.put(province, count75Plus);
}

this.currentYearPopulationByProvince = provincePopulationCountAll;
this.currentYearPopulationOver65ByProvince = provincePopulationCount65Plus;
this.currentYearPopulationOver75ByProvince = provincePopulationCount75Plus;
/*ALCODEEND*/}

double getHistoricPopulationMaxYear()
{/*ALCODESTART::1737147849357*/
Set<Integer> yearSet = this.historicPopulationData.keySet();
return Collections.max(yearSet);
/*ALCODEEND*/}

HashMap<String, HashMap<String,Integer>> calculatePSWChange()
{/*ALCODESTART::1737561506309*/
HashMap<String, HashMap<String,Integer>> changeByProvinceWorkSetting = new HashMap<>();

HashMap<String, Integer> countPSWByProvinceHC = new HashMap<>();
HashMap<String, Integer> countPSWByProvinceRC = new HashMap<>();
HashMap<String, Integer> countPSWByProvinceHS = new HashMap<>();

for(String province : provinceList) {
	countPSWByProvinceHC.put(province, this.PSWListsByProvinceAndWork.get(province).get("HC").size());
	countPSWByProvinceRC.put(province, this.PSWListsByProvinceAndWork.get(province).get("RC").size());
	countPSWByProvinceHS.put(province, this.PSWListsByProvinceAndWork.get(province).get("HS").size());
}



for(String province : provinceList) {
	int population65Plus = (int)round(currentYearPopulationOver65ByProvince.get(province) / modelPSWScalingFactor);
	int population75Plus = (int)round(currentYearPopulationOver75ByProvince.get(province) / modelPSWScalingFactor);
	
	HashMap<String,Double> targetRatioMap = null;
	
	if(recalculatePSWRatesYearly) {
		targetRatioMap = this.getPSWRates(province);
	} else {
		if(!this.provincePSWRate.containsKey(province)) {
			this.provincePSWRate.put(province, this.getPSWRates(province));
		}
		targetRatioMap = this.provincePSWRate.get(province);
	}
	
	int countTargetPSW_HC = (int)round((targetRatioMap.get("HC") / 100.0) * (double)population75Plus);
	int countTargetPSW_RC = (int)round((targetRatioMap.get("RC") / 100.0) * (double)population75Plus);
	int countTargetPSW_HS = (int)round((targetRatioMap.get("HS") / 100.0) * (double)population75Plus);
	
	int changeNeededPSW_HC = countTargetPSW_HC - countPSWByProvinceHC.get(province);// + (int)round(normal(10, 0));
	int changeNeededPSW_RC = countTargetPSW_RC - countPSWByProvinceRC.get(province);// + (int)round(normal(10, 0));
	int changeNeededPSW_HS = countTargetPSW_HS - countPSWByProvinceHS.get(province);// + (int)round(normal(10, 0));
	
	if(!changeByProvinceWorkSetting.containsKey("HC")) {
		changeByProvinceWorkSetting.put("HC", new HashMap<String, Integer>());
	}
	changeByProvinceWorkSetting.get("HC").put(province, changeNeededPSW_HC);
	
	if(!changeByProvinceWorkSetting.containsKey("RC")) {
		changeByProvinceWorkSetting.put("RC", new HashMap<String, Integer>());
	}
	changeByProvinceWorkSetting.get("RC").put(province, changeNeededPSW_RC);
	
	if(!changeByProvinceWorkSetting.containsKey("HS")) {
		changeByProvinceWorkSetting.put("HS", new HashMap<String, Integer>());
	}
	changeByProvinceWorkSetting.get("HS").put(province, changeNeededPSW_HS);
}

return changeByProvinceWorkSetting;
/*ALCODEEND*/}

double adjustPSWPopulation()
{/*ALCODESTART::1737562735843*/
if(this.getYear() <= this.getHistoricPSWMaxYear()){
	HashMap<String, HashMap<String, Integer>> countPSWByProvince = new HashMap<>();
	
	for(String province : provinceList) {
		if(!countPSWByProvince.containsKey(province)) {
			countPSWByProvince.put(province, new HashMap<>());
		}
		
		for(String workSetting : Arrays.asList("HC", "RC", "HS")) {
			countPSWByProvince.get(province).put(workSetting, this.PSWListsByProvinceAndWork.get(province).get(workSetting).size());
		}
	}
	
	for(String province : provinceList) {
		for(String workSetting : Arrays.asList("HC", "RC", "HS")) {
			int changePSW = this.getHistoricData(province, this.workSettingShortToLong(workSetting)) - countPSWByProvince.get(province).get(workSetting);
			if(changePSW < 0) {
				HashMap<Integer, PSW> PSWList = getMultipleRandomPSWsFromList(this.PSWListsByProvinceAndWork.get(province).get(workSetting), Math.abs(changePSW));
				for(Integer key : new ArrayList<>(PSWList.keySet())) {
					PSW p = PSWList.get(key);
					this.PSWListsByProvinceAndWork.get(p.province).get(p.workSetting).remove(key, p);
					this.remove_PSWs(p);
				}
			} else {
				for(int i = 0; i < Math.abs(changePSW); i++) {
					PSW p = this.add_PSWs(randomTrue(0.5) ? "male" : "female", randomTrue(0.5) ? "18to45" : "45+", province, workSetting);
					if(!this.PSWListsByProvinceAndWork.containsKey(p.province)) {
						this.PSWListsByProvinceAndWork.put(p.province, new HashMap<>());
					}
					if(!this.PSWListsByProvinceAndWork.get(p.province).containsKey(p.workSetting)) {
						this.PSWListsByProvinceAndWork.get(p.province).put(p.workSetting, new HashMap<>());
					}
					this.PSWListsByProvinceAndWork.get(p.province).get(p.workSetting).put(p.getId(), p);
				}
			}
		}
	}
}
else {
	HashMap<String, HashMap<String,Integer>> changeByProvinceWorkSetting = calculatePSWChange();
	
	for(String province : provinceList) {
		for(String workSetting : Arrays.asList("HC", "RC", "HS")) {
			int changePSW = changeByProvinceWorkSetting.get(workSetting).get(province);
			if(changePSW < 0) {
				HashMap<Integer, PSW> PSWList = getMultipleRandomPSWsFromList(this.PSWListsByProvinceAndWork.get(province).get(workSetting), Math.abs(changePSW));
				for(Integer key : new ArrayList<>(PSWList.keySet())) {
					PSW p = PSWList.get(key);
					this.PSWListsByProvinceAndWork.get(p.province).get(p.workSetting).remove(key, p);
					this.remove_PSWs(p);
				}
			} else {
				for(int i = 0; i < Math.abs(changePSW); i++) {
					PSW p = this.add_PSWs(randomTrue(0.5) ? "male" : "female", randomTrue(0.5) ? "18to45" : "45+", province, workSetting);
					if(!this.PSWListsByProvinceAndWork.containsKey(p.province)) {
						this.PSWListsByProvinceAndWork.put(p.province, new HashMap<>());
					}
					if(!this.PSWListsByProvinceAndWork.get(p.province).containsKey(p.workSetting)) {
						this.PSWListsByProvinceAndWork.get(p.province).put(p.workSetting, new HashMap<>());
					}
					this.PSWListsByProvinceAndWork.get(p.province).get(p.workSetting).put(p.getId(), p);
				}
			}
		}
	}
}
/*ALCODEEND*/}

double setupTargetRatios(Simulation simulation)
{/*ALCODESTART::1737573948820*/
for(String province : provinceList) {
	switch(province) {
		case "NL":
			NL_HC_Ratio_Mean = simulation.NL_TargetRatio_HC.getValue();
			NL_RC_Ratio_Mean = simulation.NL_TargetRatio_RC.getValue();
			NL_HS_Ratio_Mean = simulation.NL_TargetRatio_HS.getValue();
			break;
		case "PEI":
			PEI_HC_Ratio_Mean = simulation.PEI_TargetRatio_HC.getValue();
			PEI_RC_Ratio_Mean = simulation.PEI_TargetRatio_RC.getValue();
			PEI_HS_Ratio_Mean = simulation.PEI_TargetRatio_HS.getValue();
			break;
		case "NS":
			NS_HC_Ratio_Mean = simulation.NS_TargetRatio_HC.getValue();
			NS_RC_Ratio_Mean = simulation.NS_TargetRatio_RC.getValue();
			NS_HS_Ratio_Mean = simulation.NS_TargetRatio_HS.getValue();
			break;
		case "NB":
			NB_HC_Ratio_Mean = simulation.NB_TargetRatio_HC.getValue();
			NB_RC_Ratio_Mean = simulation.NB_TargetRatio_RC.getValue();
			NB_HS_Ratio_Mean = simulation.NB_TargetRatio_HS.getValue();
			break;
		case "QC":
			QC_HC_Ratio_Mean = simulation.QC_TargetRatio_HC.getValue();
			QC_RC_Ratio_Mean = simulation.QC_TargetRatio_RC.getValue();
			QC_HS_Ratio_Mean = simulation.QC_TargetRatio_HS.getValue();
			break;
		case "ON":
			ON_HC_Ratio_Mean = simulation.ON_TargetRatio_HC.getValue();
			ON_RC_Ratio_Mean = simulation.ON_TargetRatio_RC.getValue();
			ON_HS_Ratio_Mean = simulation.ON_TargetRatio_HS.getValue();
			break;
		case "MB":
			MB_HC_Ratio_Mean = simulation.MB_TargetRatio_HC.getValue();
			MB_RC_Ratio_Mean = simulation.MB_TargetRatio_RC.getValue();
			MB_HS_Ratio_Mean = simulation.MB_TargetRatio_HS.getValue();
			break;
		case "SK":
			SK_HC_Ratio_Mean = simulation.SK_TargetRatio_HC.getValue();
			SK_RC_Ratio_Mean = simulation.SK_TargetRatio_RC.getValue();
			SK_HS_Ratio_Mean = simulation.SK_TargetRatio_HS.getValue();
			break;
		case "AB":
			AB_HC_Ratio_Mean = simulation.AB_TargetRatio_HC.getValue();
			AB_RC_Ratio_Mean = simulation.AB_TargetRatio_RC.getValue();
			AB_HS_Ratio_Mean = simulation.AB_TargetRatio_HS.getValue();
			break;
		case "BC":
			BC_HC_Ratio_Mean = simulation.BC_TargetRatio_HC.getValue();
			BC_RC_Ratio_Mean = simulation.BC_TargetRatio_RC.getValue();
			BC_HS_Ratio_Mean = simulation.BC_TargetRatio_HS.getValue();
			break;
		case "YT":
			YT_HC_Ratio_Mean = simulation.YT_TargetRatio_HC.getValue();
			YT_RC_Ratio_Mean = simulation.YT_TargetRatio_RC.getValue();
			YT_HS_Ratio_Mean = simulation.YT_TargetRatio_HS.getValue();
			break;
		case "NT":
			NT_HC_Ratio_Mean = simulation.NT_TargetRatio_HC.getValue();
			NT_RC_Ratio_Mean = simulation.NT_TargetRatio_RC.getValue();
			NT_HS_Ratio_Mean = simulation.NT_TargetRatio_HS.getValue();
			break;
		case "NU":
			NU_HC_Ratio_Mean = simulation.NU_TargetRatio_HC.getValue();
			NU_RC_Ratio_Mean = simulation.NU_TargetRatio_RC.getValue();
			NU_HS_Ratio_Mean = simulation.NU_TargetRatio_HS.getValue();
			break;
		default:
			error("Province Abbreviation not recognized!");
			break;
	}
}
/*ALCODEEND*/}

String outputParamterValues()
{/*ALCODESTART::1742995690414*/
List<String> exclusionNames = new ArrayList<>();
exclusionNames.addAll(Arrays.asList("provinceList", "ageListAll", "ageList65Plus", "ageList75Plus", "sexList", "genderList", "modelPSWScalingFactor"));

StringBuilder outputStr = new StringBuilder();

outputStr.append("Name,Value,Type\n");

String[] paramNames = this.getParameterNames();
//int seedVal = this.getExperiment().getDefaultRandomGenerator().

for(String paramName : paramNames) {
	if(exclusionNames.contains(paramName)) {
		continue;
	}
	else {
		outputStr.append(paramName);
		outputStr.append(",");
		
		Object param = this.getParameter(paramName);
		if(param.getClass() == String.class) {
			outputStr.append(param);
		}
		//else if(param.getClass() == Integer.class) {
		//	outputStr.append(param);
		//}
		//else if(param.getClass() == Double.class) {
		//	outputStr.append(param);
		//}
		//else if(param.getClass() == Float.class) {
		//	outputStr.append(param);
		//}
		else {
			outputStr.append(param);
		}	
	
		//outputStr.append(this.getParameter(paramName));
		outputStr.append(",");
		outputStr.append(this.getParameter(paramName).getClass().getSimpleName());
		outputStr.append("\n");
	}
}

return outputStr.toString();
/*ALCODEEND*/}

double importPSWData()
{/*ALCODESTART::1754937168721*/
this.historicPSWData = this.readPSWData(this.PSWHistoricName);

//this.projectionPopulationData = this.readPopulationData(populationProjectionFile);

/*ALCODEEND*/}

HashMap<Integer, HashMap<String, HashMap<String, HashMap<String, Double>>>> readPSWData(String fileName)
{/*ALCODESTART::1754937168723*/
String filePath = "./data/" + fileName + ".csv";
File f = new File(filePath);

if(!f.exists() || f.isDirectory()) {
	error("The filename: \"" + fileName + "\" does not exist in the data folder.");
}

HashMap<Integer, HashMap<String, HashMap<String, HashMap<String, Double>>>> pswMap = new HashMap<>();

String line;
String[] columnNames = new String[0];
int dataLineCount = 0;
int yearIdx = -1;
int geographyIdx = -1;
int industryIdx = -1;
int statisticIdx = -1;
int valueIdx = -1;

try (BufferedReader br = new BufferedReader(new FileReader(filePath))) {
	while((line = br.readLine()) != null) {
	
		dataLineCount++;
		List columnNamesList = null;
		if(dataLineCount == 1) {
			String cleanedLine = line.trim();
			columnNamesList = Arrays.asList(cleanedLine.split(","));
			yearIdx = columnNamesList.indexOf("Year");
			geographyIdx = columnNamesList.indexOf("Geography");
			industryIdx = columnNamesList.indexOf("Industry");
			statisticIdx = columnNamesList.indexOf("Statistics");
			valueIdx = columnNamesList.indexOf("Value");
			continue;
		}

		String[] lineParts = line.split(",");
		
		int year = Integer.valueOf(lineParts[yearIdx]);
		String geography = this.provinceLongToShort(lineParts[geographyIdx]);
		String industry = lineParts[industryIdx];
		String statistics = lineParts[statisticIdx];
		double value = 0.0;
		if(lineParts[valueIdx].equals("x") || lineParts[valueIdx].equals("..") || lineParts[valueIdx].equals("F")) {
			value = -1;
		} else {
			try {
				value = Double.valueOf(Integer.valueOf(lineParts[valueIdx]));
			} 
			catch(NumberFormatException e) {
				value = Double.valueOf(lineParts[valueIdx]);
			}
		}
		
		if(!pswMap.containsKey(year)) {
			pswMap.put(year, new HashMap<>());
		}
		if(!pswMap.get(year).containsKey(geography)) {
			pswMap.get(year).put(geography, new HashMap<>());
		}
		if(!pswMap.get(year).get(geography).containsKey(industry)) {
			pswMap.get(year).get(geography).put(industry, new HashMap<>());
		}
		if(!pswMap.get(year).get(geography).get(industry).containsKey(statistics)) {
			pswMap.get(year).get(geography).get(industry).put(statistics, value);
		}

	}
}
catch (FileNotFoundException ex) {
	error(ex.getMessage());
}
catch (IOException ex) {
	error(ex.getMessage());
}
return pswMap;
/*ALCODEEND*/}

double getHistoricPSWMaxYear()
{/*ALCODESTART::1754941636292*/
Set<Integer> yearSet = this.historicPSWData.keySet();
return Collections.max(yearSet);
/*ALCODEEND*/}

int getHistoricData(String province,String workSetting)
{/*ALCODESTART::1754941856495*/
int currentYear = this.getYear();

if(this.historicPSWData.get(currentYear) == null) {
	traceln("Error getting historical data with Year: " + String.valueOf(currentYear));
}
if(this.historicPSWData.get(currentYear).get(province) == null) {
	traceln("Error getting historical data with Province: " + province);
}
if(this.historicPSWData.get(currentYear).get(province).get(workSetting) == null) {
	traceln("Error getting historical data with workSetting: " + workSetting);
}
if(this.historicPSWData.get(currentYear).get(province).get(workSetting).get("Estimates") == null) {
	traceln("Error getting historical data with Type: Estimates");
	traceln(this.historicPSWData.get(currentYear).get(province).get(workSetting));
}
if(this.historicPSWData.get(currentYear).get(province).get(workSetting).get("SD") == null) {
	traceln("Error getting historical data with Type: SD");
}

double estimate = this.historicPSWData.get(currentYear).get(province).get(workSetting).get("Estimates");
double sd = this.historicPSWData.get(currentYear).get(province).get(workSetting).get("SD");

if(estimate == -1 || sd == -1) {
	return 100;
} else {
	double sample = normal(max(0,estimate-(sd*4)), estimate+(sd*4), sd, estimate);
	
	return (int) Math.round(sample);
}
/*ALCODEEND*/}

String provinceLongToShort(String province)
{/*ALCODESTART::1754946111591*/
switch(province) {
case "Newfoundland and Labrador":
	return "NL";
case "Prince Edward Island":
	return "PEI";
case "Nova Scotia":
	return "NS";
case "New Brunswick":
	return "NB";
case "Quebec":
	return "QC";
case "Ontario":
	return "ON";
case "Manitoba":
	return "MB";
case "Saskatchewan":
	return "SK";
case "Alberta":
	return "AB";
case "British Columbia":
	return "BC";
case "Yukon":
	return "YT";
case "Northwest Territories":
	return "NT";
case "Nunavut":
	return "NU";
case "Canada":
	return "Canada";
case "Atlantic region":
	return "Atlantic region";
case "All Territories":
	return "All Territories";
default:
	error("Unsupported Province/Territory given to province name conversion: " + province);
}
return "";
/*ALCODEEND*/}

String provinceShortToLong(String province)
{/*ALCODESTART::1754946121025*/
switch(province) {
case "NL":
	return "Newfoundland and Labrador";
case "PEI":
	return "Prince Edward Island";
case "NS":
	return "Nova Scotia";
case "NB":
	return "New Brunswick";
case "QC":
	return "Quebec";
case "ON":
	return "Ontario";
case "MB":
	return "Manitoba";
case "SK":
	return "Saskatchewan";
case "AB":
	return "Alberta";
case "BC":
	return "British Columbia";
case "YT":
	return "Yukon";
case "NT":
	return "Northwest Territories";
case "NU":
	return "Nunavut";
case "Canada":
	return "Canada";
case "Atlantic region":
	return "Atlantic region";
case "All Territories":
	return "All Territories";
default:
	error("Unsupported Province/Territory given to province name conversion!");
}
return "";
/*ALCODEEND*/}

HashMap<Integer, PSW> getMultipleRandomPSWsFromList(HashMap<Integer, PSW> pswList,int n)
{/*ALCODESTART::1754950571464*/
if(n < pswList.size()) {
	List<Integer> keyList = new ArrayList<>(pswList.keySet());
	Collections.shuffle(keyList);
	
	HashMap<Integer, PSW> subPSWList = new HashMap<>();
	
	List<Integer> subKeyList = keyList.subList(0, n);
	
	for(Integer key : subKeyList) {
		subPSWList.put(key, pswList.get(key));
	}
	
	return subPSWList;
} else {
	return pswList;
}
/*ALCODEEND*/}

String workSettingShortToLong(String workSetting)
{/*ALCODESTART::1755024271270*/
switch(workSetting) {
case "HC":
	return "Home care";
case "RC":
	return "Residential care";
case "HS":
	return "Hospital sector";
default:
	error("Unsupported Work Setting given to work setting name conversion!");
}
return "";
/*ALCODEEND*/}

String workSettingLongToShort(String workSetting)
{/*ALCODESTART::1755024282272*/
switch(workSetting) {
case "Home care":
	return "HC";
case "Residential care":
	return "RC";
case "Hospital sector":
	return "HS";
default:
	error("Unsupported Work Setting given to work setting name conversion!");
}
return "";
/*ALCODEEND*/}

double initializePSWLists()
{/*ALCODESTART::1755025050778*/
HashMap<String, HashMap<String, HashMap<Integer, PSW>>> pswMap = new HashMap<>();

for(String province : provinceList) {
	if(!pswMap.containsKey(province)) {
		pswMap.put(province, new HashMap<>());
	}
	for(String work : Arrays.asList("HC", "RC", "HS")) {
		HashMap<Integer, PSW> pswList = new HashMap<>();
		pswMap.get(province).put(work, pswList);
	}
}

this.PSWListsByProvinceAndWork = pswMap;
/*ALCODEEND*/}

double writeTotalDataFile()
{/*ALCODESTART::1755189756148*/
String filePath = "./output/AllDataOutput" + String.valueOf(this.iterationNum) + ".csv";
	
StringBuilder allDataString = new StringBuilder();	
	
allDataString.append(this.getOutputHeader());
allDataString.append("\n");

for(int i = 2000; i<=2048; i++) {
	allDataString.append(this.getOutputLine(i));
}

	
try {
File f = new File(filePath);
FileWriter fr = new FileWriter(f);
PrintWriter printWriter = new PrintWriter(fr);

printWriter.write(allDataString.toString());

printWriter.close();
fr.close();
}
catch (FileNotFoundException ex) {
	error(ex.getMessage());
}
catch (IOException ex) {
	error(ex.getMessage());
}
traceln("Finished Writing results");
/*ALCODEEND*/}

String getOutputLine(int year)
{/*ALCODESTART::1755189879995*/
StringBuilder line = new StringBuilder();

line.append(String.valueOf(year));
line.append(",");

line.append("AB");
line.append(",");
line.append((new BigDecimal(this.AB_Pop_All.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_Pop_75.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_HC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_RC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_HS_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_All_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_HC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_RC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_HS_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_All_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_HC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_RC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_HS_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_All_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_HC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_RC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_HS_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.AB_All_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append("\n");

line.append(String.valueOf(year));
line.append(",");

line.append("BC");
line.append(",");
line.append((new BigDecimal(this.BC_Pop_All.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_Pop_75.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_HC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_RC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_HS_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_All_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_HC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_RC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_HS_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_All_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_HC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_RC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_HS_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_All_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_HC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_RC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_HS_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.BC_All_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append("\n");

line.append(String.valueOf(year));
line.append(",");

line.append("MB");
line.append(",");
line.append((new BigDecimal(this.MB_Pop_All.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_Pop_75.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_HC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_RC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_HS_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_All_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_HC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_RC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_HS_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_All_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_HC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_RC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_HS_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_All_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_HC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_RC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_HS_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.MB_All_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append("\n");

line.append(String.valueOf(year));
line.append(",");

line.append("NB");
line.append(",");
line.append((new BigDecimal(this.NB_Pop_All.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_Pop_75.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_HC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_RC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_HS_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_All_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_HC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_RC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_HS_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_All_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_HC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_RC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_HS_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_All_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_HC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_RC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_HS_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NB_All_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append("\n");

line.append(String.valueOf(year));
line.append(",");

line.append("NL");
line.append(",");
line.append((new BigDecimal(this.NL_Pop_All.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_Pop_75.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_HC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_RC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_HS_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_All_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_HC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_RC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_HS_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_All_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_HC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_RC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_HS_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_All_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_HC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_RC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_HS_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NL_All_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append("\n");

line.append(String.valueOf(year));
line.append(",");

line.append("NS");
line.append(",");
line.append((new BigDecimal(this.NS_Pop_All.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_Pop_75.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_HC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_RC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_HS_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_All_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_HC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_RC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_HS_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_All_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_HC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_RC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_HS_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_All_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_HC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_RC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_HS_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NS_All_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append("\n");

line.append(String.valueOf(year));
line.append(",");

line.append("NT");
line.append(",");
line.append((new BigDecimal(this.NT_Pop_All.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_Pop_75.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_HC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_RC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_HS_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_All_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_HC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_RC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_HS_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_All_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_HC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_RC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_HS_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_All_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_HC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_RC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_HS_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NT_All_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append("\n");

line.append(String.valueOf(year));
line.append(",");

line.append("ON");
line.append(",");
line.append((new BigDecimal(this.ON_Pop_All.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_Pop_75.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_HC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_RC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_HS_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_All_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_HC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_RC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_HS_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_All_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_HC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_RC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_HS_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_All_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_HC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_RC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_HS_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.ON_All_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append("\n");

line.append(String.valueOf(year));
line.append(",");

line.append("PEI");
line.append(",");
line.append((new BigDecimal(this.PEI_Pop_All.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_Pop_75.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_HC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_RC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_HS_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_All_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_HC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_RC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_HS_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_All_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_HC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_RC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_HS_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_All_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_HC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_RC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_HS_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.PEI_All_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append("\n");

line.append(String.valueOf(year));
line.append(",");

line.append("QC");
line.append(",");
line.append((new BigDecimal(this.QC_Pop_All.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_Pop_75.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_HC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_RC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_HS_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_All_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_HC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_RC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_HS_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_All_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_HC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_RC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_HS_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_All_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_HC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_RC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_HS_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.QC_All_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append("\n");

line.append(String.valueOf(year));
line.append(",");

line.append("SK");
line.append(",");
line.append((new BigDecimal(this.SK_Pop_All.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_Pop_75.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_HC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_RC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_HS_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_All_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_HC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_RC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_HS_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_All_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_HC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_RC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_HS_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_All_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_HC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_RC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_HS_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.SK_All_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append("\n");


line.append(String.valueOf(year));
line.append(",");

line.append("YT");
line.append(",");
line.append((new BigDecimal(this.YT_Pop_All.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_Pop_75.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_HC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_RC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_HS_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_All_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_HC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_RC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_HS_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_All_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_HC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_RC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_HS_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_All_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_HC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_RC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_HS_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.YT_All_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append("\n");

line.append(String.valueOf(year));
line.append(",");

line.append("NU");
line.append(",");
line.append((new BigDecimal(this.NU_Pop_All.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_Pop_75.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_HC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_RC_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_HS_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_All_Count_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_HC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_RC_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_HS_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_All_Capita_Whole_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_HC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_RC_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_HS_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_All_Capita_65Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_HC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_RC_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_HS_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append(",");
line.append((new BigDecimal(this.NU_All_Capita_75Plus_DS.getY(year-2000))).toPlainString());
line.append("\n");

return line.toString();
/*ALCODEEND*/}

String getOutputHeader()
{/*ALCODESTART::1755189887930*/
StringBuilder header = new StringBuilder();

header.append("Year");
header.append(",");
header.append("Geography");
header.append(",");
header.append("PopulationAll");
header.append(",");
header.append("Population75+");
header.append(",");
header.append("PSWCountHC");
header.append(",");
header.append("PSWCountRC");
header.append(",");
header.append("PSWCountHS");
header.append(",");
header.append("PSWCountAll");
header.append(",");
header.append("PSWCapitaWholeHC");
header.append(",");
header.append("PSWCapitaWholeRC");
header.append(",");
header.append("PSWCapitaWholeHS");
header.append(",");
header.append("PSWCapitaWholeAll");
header.append(",");
header.append("PSWCapita65PlusHC");
header.append(",");
header.append("PSWCapita65PlusRC");
header.append(",");
header.append("PSWCapita65PlusHS");
header.append(",");
header.append("PSWCapita65PlusAll");
header.append(",");
header.append("PSWCapita75PlusHC");
header.append(",");
header.append("PSWCapita75PlusRC");
header.append(",");
header.append("PSWCapita75PlusHS");
header.append(",");
header.append("PSWCapita75PlusAll");
return header.toString();
/*ALCODEEND*/}

HashMap<String,Double> getPSWRates(String province)
{/*ALCODESTART::1755812316424*/
HashMap<String,Double> returnMap = new HashMap<>();

String provinceHCRatioName = province + "_HC_Ratio";
String provinceRCRatioName = province + "_RC_Ratio";
String provinceHSRatioName = province + "_HS_Ratio";

double targetRatioPSW_HC_Mean = this.getParameter((provinceHCRatioName+"_Mean"));
double targetRatioPSW_RC_Mean = this.getParameter((provinceRCRatioName+"_Mean"));
double targetRatioPSW_HS_Mean = this.getParameter((provinceHSRatioName+"_Mean"));

double targetRatioPSW_HC_SD = this.getParameter((provinceHCRatioName+"_SD"));
double targetRatioPSW_RC_SD = this.getParameter((provinceRCRatioName+"_SD"));
double targetRatioPSW_HS_SD = this.getParameter((provinceHSRatioName+"_SD"));


//Home Care
double truncateMin_HC = max(0,targetRatioPSW_HC_Mean-(targetRatioPSW_HC_SD*4.0));
double truncateMax_HC = targetRatioPSW_HC_Mean+(targetRatioPSW_HC_SD*4.0);

returnMap.put("HC", normal(truncateMin_HC, truncateMax_HC, targetRatioPSW_HC_Mean, targetRatioPSW_HC_SD));


//Residential Care
double truncateMin_RC = max(0,targetRatioPSW_RC_Mean-(targetRatioPSW_RC_SD*4.0));
double truncateMax_RC = targetRatioPSW_RC_Mean+(targetRatioPSW_RC_SD*4.0);

returnMap.put("RC", normal(truncateMin_RC, truncateMax_RC, targetRatioPSW_RC_Mean, targetRatioPSW_RC_SD));


//Hospital
double truncateMin_HS = max(0,targetRatioPSW_HS_Mean-(targetRatioPSW_HS_SD*4.0));
double truncateMax_HS = targetRatioPSW_HS_Mean+(targetRatioPSW_HS_SD*4.0);

returnMap.put("HS", normal(truncateMin_HS, truncateMax_HS, targetRatioPSW_HS_Mean, targetRatioPSW_HS_SD));
	
	
return returnMap;
/*ALCODEEND*/}

double countPSWs()
{/*ALCODESTART::1758296341768*/
countPSWByProvinceHomeCare.clear();
countPSWByProvinceResidentialCare.clear();
countPSWByProvinceHospital.clear();

int countPSW_HC = 0;
int countPSW_RC = 0;
int countPSW_HS = 0;

for(String province : provinceList) {
	countPSWByProvinceHomeCare.put(province, this.PSWListsByProvinceAndWork.get(province).get("HC").size());
	countPSW_HC += this.PSWListsByProvinceAndWork.get(province).get("HC").size();
	countPSWByProvinceResidentialCare.put(province, this.PSWListsByProvinceAndWork.get(province).get("RC").size());
	countPSW_RC += this.PSWListsByProvinceAndWork.get(province).get("RC").size();
	countPSWByProvinceHospital.put(province, this.PSWListsByProvinceAndWork.get(province).get("HS").size());
	countPSW_HS += this.PSWListsByProvinceAndWork.get(province).get("HS").size();
}


countPSWHomeCare = countPSW_HC;
countPSWResidentialCare = countPSW_RC;
countPSWHospital = countPSW_HS;

countPSW = countPSW_HC + countPSW_RC + countPSW_HS;
/*ALCODEEND*/}

double updatePSW_DSs()
{/*ALCODESTART::1758297983661*/
/* Newfoundland and Labrador Data Update*/
NL_All_Count_DS.update();
NL_HC_Count_DS.update();
NL_HS_Count_DS.update();
NL_RC_Count_DS.update();

NL_All_Capita_Whole_DS.update();
NL_HC_Capita_Whole_DS.update();
NL_RC_Capita_Whole_DS.update();
NL_HS_Capita_Whole_DS.update();

NL_All_Capita_65Plus_DS.update();
NL_HC_Capita_65Plus_DS.update();
NL_RC_Capita_65Plus_DS.update();
NL_HS_Capita_65Plus_DS.update();

NL_All_Capita_75Plus_DS.update();
NL_HC_Capita_75Plus_DS.update();
NL_RC_Capita_75Plus_DS.update();
NL_HS_Capita_75Plus_DS.update();

/* Prince Edward Island Data Update*/
PEI_All_Count_DS.update();
PEI_HC_Count_DS.update();
PEI_HS_Count_DS.update();
PEI_RC_Count_DS.update();

PEI_All_Capita_Whole_DS.update();
PEI_HC_Capita_Whole_DS.update();
PEI_RC_Capita_Whole_DS.update();
PEI_HS_Capita_Whole_DS.update();

PEI_All_Capita_65Plus_DS.update();
PEI_HC_Capita_65Plus_DS.update();
PEI_RC_Capita_65Plus_DS.update();
PEI_HS_Capita_65Plus_DS.update();

PEI_All_Capita_75Plus_DS.update();
PEI_HC_Capita_75Plus_DS.update();
PEI_RC_Capita_75Plus_DS.update();
PEI_HS_Capita_75Plus_DS.update();

/* Nova Scotia Data Update*/
NS_All_Count_DS.update();
NS_HC_Count_DS.update();
NS_HS_Count_DS.update();
NS_RC_Count_DS.update();

NS_All_Capita_Whole_DS.update();
NS_HC_Capita_Whole_DS.update();
NS_RC_Capita_Whole_DS.update();
NS_HS_Capita_Whole_DS.update();

NS_All_Capita_65Plus_DS.update();
NS_HC_Capita_65Plus_DS.update();
NS_RC_Capita_65Plus_DS.update();
NS_HS_Capita_65Plus_DS.update();

NS_All_Capita_75Plus_DS.update();
NS_HC_Capita_75Plus_DS.update();
NS_RC_Capita_75Plus_DS.update();
NS_HS_Capita_75Plus_DS.update();

/* New Brunswick Data Update*/
NB_All_Count_DS.update();
NB_HC_Count_DS.update();
NB_HS_Count_DS.update();
NB_RC_Count_DS.update();

NB_All_Capita_Whole_DS.update();
NB_HC_Capita_Whole_DS.update();
NB_RC_Capita_Whole_DS.update();
NB_HS_Capita_Whole_DS.update();

NB_All_Capita_65Plus_DS.update();
NB_HC_Capita_65Plus_DS.update();
NB_RC_Capita_65Plus_DS.update();
NB_HS_Capita_65Plus_DS.update();

NB_All_Capita_75Plus_DS.update();
NB_HC_Capita_75Plus_DS.update();
NB_RC_Capita_75Plus_DS.update();
NB_HS_Capita_75Plus_DS.update();

/* Quebec Data Update*/
QC_All_Count_DS.update();
QC_HC_Count_DS.update();
QC_HS_Count_DS.update();
QC_RC_Count_DS.update();

QC_All_Capita_Whole_DS.update();
QC_HC_Capita_Whole_DS.update();
QC_RC_Capita_Whole_DS.update();
QC_HS_Capita_Whole_DS.update();

QC_All_Capita_65Plus_DS.update();
QC_HC_Capita_65Plus_DS.update();
QC_RC_Capita_65Plus_DS.update();
QC_HS_Capita_65Plus_DS.update();

QC_All_Capita_75Plus_DS.update();
QC_HC_Capita_75Plus_DS.update();
QC_RC_Capita_75Plus_DS.update();
QC_HS_Capita_75Plus_DS.update();

/* Ontario Data Update*/
ON_All_Count_DS.update();
ON_HC_Count_DS.update();
ON_HS_Count_DS.update();
ON_RC_Count_DS.update();

ON_All_Capita_Whole_DS.update();
ON_HC_Capita_Whole_DS.update();
ON_RC_Capita_Whole_DS.update();
ON_HS_Capita_Whole_DS.update();

ON_All_Capita_65Plus_DS.update();
ON_HC_Capita_65Plus_DS.update();
ON_RC_Capita_65Plus_DS.update();
ON_HS_Capita_65Plus_DS.update();

ON_All_Capita_75Plus_DS.update();
ON_HC_Capita_75Plus_DS.update();
ON_RC_Capita_75Plus_DS.update();
ON_HS_Capita_75Plus_DS.update();

/* Manitoba Data Update*/
MB_All_Count_DS.update();
MB_HC_Count_DS.update();
MB_HS_Count_DS.update();
MB_RC_Count_DS.update();

MB_All_Capita_Whole_DS.update();
MB_HC_Capita_Whole_DS.update();
MB_RC_Capita_Whole_DS.update();
MB_HS_Capita_Whole_DS.update();

MB_All_Capita_65Plus_DS.update();
MB_HC_Capita_65Plus_DS.update();
MB_RC_Capita_65Plus_DS.update();
MB_HS_Capita_65Plus_DS.update();

MB_All_Capita_75Plus_DS.update();
MB_HC_Capita_75Plus_DS.update();
MB_RC_Capita_75Plus_DS.update();
MB_HS_Capita_75Plus_DS.update();

/* Saskatchewan Data Update*/
SK_All_Count_DS.update();
SK_HC_Count_DS.update();
SK_HS_Count_DS.update();
SK_RC_Count_DS.update();

SK_All_Capita_Whole_DS.update();
SK_HC_Capita_Whole_DS.update();
SK_RC_Capita_Whole_DS.update();
SK_HS_Capita_Whole_DS.update();

SK_All_Capita_65Plus_DS.update();
SK_HC_Capita_65Plus_DS.update();
SK_RC_Capita_65Plus_DS.update();
SK_HS_Capita_65Plus_DS.update();

SK_All_Capita_75Plus_DS.update();
SK_HC_Capita_75Plus_DS.update();
SK_RC_Capita_75Plus_DS.update();
SK_HS_Capita_75Plus_DS.update();

/* Alberta Data Update*/
AB_All_Count_DS.update();
AB_HC_Count_DS.update();
AB_HS_Count_DS.update();
AB_RC_Count_DS.update();

AB_All_Capita_Whole_DS.update();
AB_HC_Capita_Whole_DS.update();
AB_RC_Capita_Whole_DS.update();
AB_HS_Capita_Whole_DS.update();

AB_All_Capita_65Plus_DS.update();
AB_HC_Capita_65Plus_DS.update();
AB_RC_Capita_65Plus_DS.update();
AB_HS_Capita_65Plus_DS.update();

AB_All_Capita_75Plus_DS.update();
AB_HC_Capita_75Plus_DS.update();
AB_RC_Capita_75Plus_DS.update();
AB_HS_Capita_75Plus_DS.update();

/* British Columbia Data Update*/
BC_All_Count_DS.update();
BC_HC_Count_DS.update();
BC_HS_Count_DS.update();
BC_RC_Count_DS.update();

BC_All_Capita_Whole_DS.update();
BC_HC_Capita_Whole_DS.update();
BC_RC_Capita_Whole_DS.update();
BC_HS_Capita_Whole_DS.update();

BC_All_Capita_65Plus_DS.update();
BC_HC_Capita_65Plus_DS.update();
BC_RC_Capita_65Plus_DS.update();
BC_HS_Capita_65Plus_DS.update();

BC_All_Capita_75Plus_DS.update();
BC_HC_Capita_75Plus_DS.update();
BC_RC_Capita_75Plus_DS.update();
BC_HS_Capita_75Plus_DS.update();

/* Yukon Data Update*/
YT_All_Count_DS.update();
YT_HC_Count_DS.update();
YT_HS_Count_DS.update();
YT_RC_Count_DS.update();

YT_All_Capita_Whole_DS.update();
YT_HC_Capita_Whole_DS.update();
YT_RC_Capita_Whole_DS.update();
YT_HS_Capita_Whole_DS.update();

YT_All_Capita_65Plus_DS.update();
YT_HC_Capita_65Plus_DS.update();
YT_RC_Capita_65Plus_DS.update();
YT_HS_Capita_65Plus_DS.update();

YT_All_Capita_75Plus_DS.update();
YT_HC_Capita_75Plus_DS.update();
YT_RC_Capita_75Plus_DS.update();
YT_HS_Capita_75Plus_DS.update();

/* Northwest Territories Data Update*/
NT_All_Count_DS.update();
NT_HC_Count_DS.update();
NT_HS_Count_DS.update();
NT_RC_Count_DS.update();

NT_All_Capita_Whole_DS.update();
NT_HC_Capita_Whole_DS.update();
NT_RC_Capita_Whole_DS.update();
NT_HS_Capita_Whole_DS.update();

NT_All_Capita_65Plus_DS.update();
NT_HC_Capita_65Plus_DS.update();
NT_RC_Capita_65Plus_DS.update();
NT_HS_Capita_65Plus_DS.update();

NT_All_Capita_75Plus_DS.update();
NT_HC_Capita_75Plus_DS.update();
NT_RC_Capita_75Plus_DS.update();
NT_HS_Capita_75Plus_DS.update();

/* Nunavut Data Update*/
NU_All_Count_DS.update();
NU_HC_Count_DS.update();
NU_HS_Count_DS.update();
NU_RC_Count_DS.update();

NU_All_Capita_Whole_DS.update();
NU_HC_Capita_Whole_DS.update();
NU_RC_Capita_Whole_DS.update();
NU_HS_Capita_Whole_DS.update();

NU_All_Capita_65Plus_DS.update();
NU_HC_Capita_65Plus_DS.update();
NU_RC_Capita_65Plus_DS.update();
NU_HS_Capita_65Plus_DS.update();

NU_All_Capita_75Plus_DS.update();
NU_HC_Capita_75Plus_DS.update();
NU_RC_Capita_75Plus_DS.update();
NU_HS_Capita_75Plus_DS.update();

/* General Data Update*/
Canada_All_Count_DS.update();
Canada_HC_Count_DS.update();
Canada_RC_Count_DS.update();
Canada_HS_Count_DS.update();

Canada_All_Capita_Whole_DS.update();
Canada_HC_Capita_Whole_DS.update();
Canada_RC_Capita_Whole_DS.update();
Canada_HS_Capita_Whole_DS.update();

Canada_All_Capita_65Plus_DS.update();
Canada_HC_Capita_65Plus_DS.update();
Canada_RC_Capita_65Plus_DS.update();
Canada_HS_Capita_65Plus_DS.update();

Canada_All_Capita_75Plus_DS.update();
Canada_HC_Capita_75Plus_DS.update();
Canada_RC_Capita_75Plus_DS.update();
Canada_HS_Capita_75Plus_DS.update();
/*ALCODEEND*/}

double calculatePSWCapitaValues()
{/*ALCODESTART::1758298394108*/
capitaWholePSWByProvinceHomeCare.clear();
capitaWholePSWByProvinceResidentialCare.clear();
capitaWholePSWByProvinceHospital.clear();
capitaWholePSWByProvinceAllWork.clear();

capita65PlusPSWByProvinceHomeCare.clear();
capita65PlusPSWByProvinceResidentialCare.clear();
capita65PlusPSWByProvinceHospital.clear();
capita65PlusPSWByProvinceAllWork.clear();

capita75PlusPSWByProvinceHomeCare.clear();
capita75PlusPSWByProvinceResidentialCare.clear();
capita75PlusPSWByProvinceHospital.clear();
capita75PlusPSWByProvinceAllWork.clear();

double perCapitaMultiplier = 10000.0; //10,000 multiplier is used to align with the CIHI PSW Indicator being developed

int allCount_HC = 0;
int allCount_RC = 0;
int allCount_HS = 0;
int allCount_All = 0;

int populationWhole = 0;
int population65Plus = 0;
int population75Plus = 0;

for(String province : provinceList) {
	int provinceCount_HC = this.PSWListsByProvinceAndWork.get(province).get("HC").size();
	int provinceCount_RC = this.PSWListsByProvinceAndWork.get(province).get("RC").size();
	int provinceCount_HS = this.PSWListsByProvinceAndWork.get(province).get("HS").size();
	int provinceCount_All = provinceCount_HC + provinceCount_RC + provinceCount_HS;
	
	int provincePopulationWhole = this.currentYearPopulationByProvince.get(province);
	int provincePopulation65Plus = this.currentYearPopulationOver65ByProvince.get(province);
	int provincePopulation75Plus = this.currentYearPopulationOver75ByProvince.get(province);
	
	allCount_HC += provinceCount_HC;
	allCount_RC += provinceCount_RC;
	allCount_HS += provinceCount_HS;
	allCount_All += provinceCount_All;
	
	populationWhole += provincePopulationWhole;
	population65Plus += provincePopulation65Plus;
	population75Plus += provincePopulation75Plus;
	
	double capitaWholePSW_HC = ((double)provinceCount_HC / (double)provincePopulationWhole) * perCapitaMultiplier;
	double capitaWholePSW_RC = ((double)provinceCount_RC / (double)provincePopulationWhole) * perCapitaMultiplier;
	double capitaWholePSW_HS = ((double)provinceCount_HS / (double)provincePopulationWhole) * perCapitaMultiplier;
	double capitaWholePSW_All = ((double)provinceCount_All / (double)provincePopulationWhole) * perCapitaMultiplier;
	
	double capita65PlusPSW_HC = ((double)provinceCount_HC / (double)provincePopulation65Plus) * perCapitaMultiplier;
	double capita65PlusPSW_RC = ((double)provinceCount_RC / (double)provincePopulation65Plus) * perCapitaMultiplier;
	double capita65PlusPSW_HS = ((double)provinceCount_HS / (double)provincePopulation65Plus) * perCapitaMultiplier;
	double capita65PlusPSW_All = ((double)provinceCount_All / (double)provincePopulation65Plus) * perCapitaMultiplier;
	
	double capita75PlusPSW_HC = ((double)provinceCount_HC / (double)provincePopulation75Plus) * perCapitaMultiplier;
	double capita75PlusPSW_RC = ((double)provinceCount_RC / (double)provincePopulation75Plus) * perCapitaMultiplier;
	double capita75PlusPSW_HS = ((double)provinceCount_HS / (double)provincePopulation75Plus) * perCapitaMultiplier;
	double capita75PlusPSW_All = ((double)provinceCount_All / (double)provincePopulation75Plus) * perCapitaMultiplier;
	
	capitaWholePSWByProvinceHomeCare.put(province, capitaWholePSW_HC);
	capitaWholePSWByProvinceResidentialCare.put(province, capitaWholePSW_RC);
	capitaWholePSWByProvinceHospital.put(province, capitaWholePSW_HS);
	capitaWholePSWByProvinceAllWork.put(province, capitaWholePSW_All);
	
	capita65PlusPSWByProvinceHomeCare.put(province, capita65PlusPSW_HC);
	capita65PlusPSWByProvinceResidentialCare.put(province, capita65PlusPSW_RC);
	capita65PlusPSWByProvinceHospital.put(province, capita65PlusPSW_HS);
	capita65PlusPSWByProvinceAllWork.put(province, capita65PlusPSW_All);
	
	capita75PlusPSWByProvinceHomeCare.put(province, capita75PlusPSW_HC);
	capita75PlusPSWByProvinceResidentialCare.put(province, capita75PlusPSW_RC);
	capita75PlusPSWByProvinceHospital.put(province, capita75PlusPSW_HS);
	capita75PlusPSWByProvinceAllWork.put(province, capita75PlusPSW_All);
}

double capitaWholePSW_Canada_HC = ((double)allCount_HC / (double)populationWhole) * perCapitaMultiplier;
double capitaWholePSW_Canada_RC = ((double)allCount_RC / (double)populationWhole) * perCapitaMultiplier;
double capitaWholePSW_Canada_HS = ((double)allCount_HS / (double)populationWhole) * perCapitaMultiplier;
double capitaWholePSW_Canada_All = ((double)allCount_All / (double)populationWhole) * perCapitaMultiplier;

double capita65PlusPSW_Canada_HC = ((double)allCount_HC / (double)population65Plus) * perCapitaMultiplier;
double capita65PlusPSW_Canada_RC = ((double)allCount_RC / (double)population65Plus) * perCapitaMultiplier;
double capita65PlusPSW_Canada_HS = ((double)allCount_HS / (double)population65Plus) * perCapitaMultiplier;
double capita65PlusPSW_Canada_All = ((double)allCount_All / (double)population65Plus) * perCapitaMultiplier;

double capita75PlusPSW_Canada_HC = ((double)allCount_HC / (double)population75Plus) * perCapitaMultiplier;
double capita75PlusPSW_Canada_RC = ((double)allCount_RC / (double)population75Plus) * perCapitaMultiplier;
double capita75PlusPSW_Canada_HS = ((double)allCount_HS / (double)population75Plus) * perCapitaMultiplier;
double capita75PlusPSW_Canada_All = ((double)allCount_All / (double)population75Plus) * perCapitaMultiplier;

capitaWholePSWHomeCare = capitaWholePSW_Canada_HC;
capitaWholePSWResidentialCare = capitaWholePSW_Canada_RC;
capitaWholePSWHospital = capitaWholePSW_Canada_HS;
capitaWholePSWAllWork = capitaWholePSW_Canada_All;

capita65PlusPSWHomeCare = capita65PlusPSW_Canada_HC;
capita65PlusPSWResidentialCare = capita65PlusPSW_Canada_RC;
capita65PlusPSWHospital = capita65PlusPSW_Canada_HS;
capita65PlusPSWAllWork = capita65PlusPSW_Canada_All;

capita75PlusPSWHomeCare = capita75PlusPSW_Canada_HC;
capita75PlusPSWResidentialCare = capita75PlusPSW_Canada_RC;
capita75PlusPSWHospital = capita75PlusPSW_Canada_HS;
capita75PlusPSWAllWork = capita75PlusPSW_Canada_All;
/*ALCODEEND*/}

